* Figure 11: Risk Aversion and the State Price Distribution
clear
set mem 200m
set obs 10000
gen n=_n
egen nmax=max(n)
gen x=-10 if n==1
replace x=10 if n==nmax
ipolate x n, g(x1)
la var x1 "Shock"
drop x

gen beta=1+.01*x
la var beta "Wealth"

sort x
gen double prob=(norm(x[_n+1])-norm(x))/(x[_n+1]-x)
for num 0 1 5 20: gen muX=beta^(-X) \ gen idenomX=prob*muX*(x[_n+1]-x) \ egen denomX=sum(idenomX) \ gen priceX=prob*muX/denomX
#delimit ;
twoway 
	(line price0 beta, sort clcolor(black) clwidth(medthick)) 
	(line price1 beta, sort clcolor(green) clpat(dot)) 
	(line price5 beta, sort clcolor(blue) clpat(dash)) 
	(line price20 beta, clcolor(orange) clpat(longdash))
	if beta>.96 & beta<1.04,
	ytitle(Probability Density \ State Price Distribution) 
	ylabel(, angle(horizontal)) 
	xtitle(Wealth Relative to Baseline) 
	xlabel(.96(.02)1.04)
	title(State Price Distributions) 
	legend(rows(4) order(1 "Actual Shock Distr." "= Risk Neutral" 2 "Log Utility" 3 "CRRA=5" 4 "CRRA=20")) 
	legend(position(10) ring(0) region(fcolor(none) lcolor(none)))
	xsize(10) ysize(7.5)
;
#delimit cr

*  Table 9: Effects of News on the S&P
use "AllDerivatives(scaled)", clear
gen beta=.
for X in any iclm napm nfpay rsxaut: reg sp500 ameanerr if statistic=="X" \ replace beta=_b[ameanerr] if statistic=="X"
gen dwealth=beta*ameanerr

********* Figure 12: Risk Premium
use "AllDerivatives", clear
gen beta=.
replace sp500=sp500/100
for X in any iclm napm nfpay rsxaut: reg sp500 ameanerr if statistic=="X" \ replace beta=_b[ameanerr] if statistic=="X" 
gen wealth=1+beta*ameanerr
for X in any 0 1 2 5 20: gen muX=wealth^(-X) \ egen summuX=sum(muX), by(statistic) \ egen countmuX=count(muX), by(statistic) \ gen pionpX=muX/(summuX/countmuX)

#delimit ;
for X in any nfpay napm rsxaut iclm:
	reg sp500 ameanerr if statistic=="X" \
	gen beta_X=_b[ameanerr] \
	gen const_X=_b[_cons] \
	egen sd_X=sd(ameanerr) if statistic=="X" \ sort sd_X \ replace sd_X=sd_X[_n-1] if sd_X==. \
	for Y in num 0 1 5 20: gen dY_X=summuY/countmuY if statistic=="X" \
	for Y in num 0 1 5 20: egen denomY_X=mode(dY_X) \
	kdensity ameanerr if statistic=="X", g(x_X d_X) n(200) \
	gen wealth_X=1+const_X+beta_X*x_X \
	for Y in num 0 1 5 20: gen piY_X=d_X*wealth_X^(-Y)/denomY_X \
;
#delimit cr

keep d_* x_* pi0_* pi1_* pi5_* pi20_* sd_*
gen n=_n
reshape long d x pi0 pi1 pi5 pi20 sd, i(n) string
rename _j statistic
gen str20 stat=""
for X in any iclm napm nfpay rsxaut \ Y in any "Initial Unemployment Claims" "Business Confidence (ISM)" "Non-Farm Payrolls"  "Retail Sales (ex Autos)": replace stat="Y" if statistic=="_X"
la var stat "Economic data series"

#delimit ;
twoway 
	(line d x, sort lcolor(none))
	(line d x, sort lcolor(black)) 
	(line pi1 x, sort lcolor(green) lpattern(dot)) 
	(line pi5 x, sort lcolor(blue) lpattern(dash)) 
	(line pi20 x, sort lcolor(orange) lpattern(longdash))
	if abs(x)<2.5*sd
,
	ytitle(Price of an Option Paying $1 if Event Occurs) 
	ylabel(, angle(horizontal)) 
	xtitle(Strike Price Relative to Auction Mean) 
	legend(colfirst cols(2) order(2 "Kernel Density Estimate" 1 "of Shock Distribution" 1 "= Risk Neutral" 1 " "  3 "Log Utility" 4 "CRRA=5" 5 "CRRA=20")) 
	legend(ring(0))
	legend(region(fcolor(none) lcolor(none)))
	xsize(10) ysize(7.5)
	by(stat,
		xrescale 
		yrescale
		title(Effects of Risk on the State Price Distribution))
;
#delimit cr

* Table 10: Measures of Central Tendency
* Panel A
use "AllDerivatives", clear
gen beta=.
replace sp500=sp500/100
for X in any iclm napm nfpay rsxaut: reg sp500 ameanerr if statistic=="X" \ replace beta=_b[ameanerr] if statistic=="X" 
gen wealth=1+beta*ameanerr
for X in any 0 1 2 5 20: gen muX=wealth^(-X) \ egen summuX=sum(muX), by(statistic) \ egen countmuX=count(muX), by(statistic) \ gen pionpX=muX/(summuX/countmuX)

for X in num 0 1 2 5 20: xi: reg ameanerr i.statistic [w=pionpX]  \ predict pricemeanX
for X in num 0 1 2 5 20: gen diffmeanX=pricemeanX-pricemean0 
table statistic, c(m diffmean0 m diffmean1 m diffmean5 m diffmean20)
pause

* Panel B
use "AllDerivatives(scaled)", clear
gen beta=.
replace sp500=sp500/100
for X in any iclm napm nfpay rsxaut: reg sp500 ameanerr if statistic=="X" \ replace beta=_b[ameanerr] if statistic=="X" 
gen wealth=1+beta*ameanerr
for X in any 0 1 2 5 20: gen muX=wealth^(-X) \ egen summuX=sum(muX), by(statistic) \ egen countmuX=count(muX), by(statistic) \ gen pionpX=muX/(summuX/countmuX)

for X in num 0 1 2 5 20: xi: reg ameanerr i.statistic [w=pionpX]  \ predict pricemeanX
for X in num 0 1 2 5 20: gen diffmeanX=pricemeanX-pricemean0 
table statistic, c(m diffmean0 m diffmean1 m diffmean5 m diffmean20)
pause

* Figure 13: Uncertainty and Forecast Errors
use "AllDerivatives", clear
#delimit ;
twoway  
	(scatter ameanerr astd) 
	(lfit ameanerr astd) 
,
	by(stat, xrescale yrescale title(Uncertainty and Risk Premia) legend(off))
	ytitle(Forecast Error: Actual - Forecast) 
	ylabel(, angle(horizontal)) 
	xtitle("Uncertainty (SD of the Market-based State Price Distribution)") 
	xsize(10) ysize(7.5)
;
#delimit cr
for X in any iclm napm nfpay rsxaut: reg ameanerr astd if statistic=="X"\ test astd
xi: reg ameanerr i.statistic*astd
testparm astd _IstaXastd*

* Figure 14: Kernel Density Estimates
use "AllDerivatives", clear

* for var binlb* binub*: replace X=(X-amean)/astd
for num 1/18: gen midX=(binlbX+binubX)/2
for num 1/18: replace midX=(midX-amean)/astd
gen actualz=(releasedval-amean)/astd
keep statistic dtrelease mid* probbin* actualz
reshape long mid probbin, i(statistic dtrelease) j(bin)
gen at=-4
set obs 8000
replace at=round(at[_n-1]+.001,.001) if at[_n-1]~=.
replace at=. if at>4.000001

kdensity mid [aweight=probbin], at(at) g(fx)
gen normx=normd(at)
egen tag=tag(statistic dtrelease)
kdensity actualz if tag==1, at(at) g(factual)
#delimit ;
twoway 
	(line normx at, sort clpat(dot) clwidth(thin))
	(line fx at, sort clwidth(medthin)) 
	(line factual at, sort clpat(longdash) clwidth(thin)) 
,
	ytitle(Estimated Density) 
	ylabel(, angle(horizontal)) 
	xtitle(Economic Outcome: z = (Strike Price - Auction Mean) / Auction SD) 
	title(State Price Distribution and the Outcome Distribution) 
	subtitle(Kernel Density Estimates - Averaging Across All Auctions) 
	legend(cols(1) order(2 "State Price Distribution" 3 "Outcome Distribution" 1 "Normal Distribution")) 
	legend(position(11) ring(0) region(fcolor(none) lcolor(none))) 
	xsize(10) ysize(7.5)
;
#delimit cr
for X in any iclm nfpay rsxaut napm: kdensity mid [aweight=probbin] if statistic=="X", at(at) g(fx_X)
for X in any iclm nfpay rsxaut napm: kdensity actualz  [aweight=probbin] if tag==1 & statistic=="X", at(at) g(factual_X)
keep fx_* factual_* at
gen n=_n
reshape long fx factual , i(n) string
rename _j statistic
gen str20 stat=""
for X in any iclm napm nfpay rsxaut \ Y in any "Initial Unemployment Claims" "Business Confidence (ISM)" "Non-Farm Payrolls"  "Retail Sales (ex Autos)": replace stat="Y" if statistic=="_X"
la var stat "Economic data series"
gen normx=normd(at)
#delimit ;
twoway 
	(line normx at, sort clpat(dot) clwidth(thin))
	(line fx at, sort clwidth(medthin)) 
	(line factual at, sort clpat(longdash) clwidth(thin)) 
,
	ytitle(Estimated Density) 
	ylabel(, angle(horizontal)) 
	xtitle(Economic Outcome: z = (Strike Price - Auction Mean) / Auction SD) 
	legend(rows(1) order(2 "State Price Distribution" 3 "Outcome Distribution" 1 "Normal Distribution")) 
	legend(position(11) ring(0) region(fcolor(none) lcolor(none))) 
	xsize(10) ysize(7.5)
	by(stat,
		title(State Price Distribution and the Outcome Distribution)
	)
;
#delimit cr

***************** Estimating Risk Aversion

use "AllDerivatives(scaled)", clear
* replace binlb1=binub1-4*(binub2-binlb2)
* egen upper=rmax(binub1 binub2 binub3 binub4 binub5 binub6 binub7 binub8 binub9 binub10 binub11 binub12 binub13 binub14 binub15 binub16 binub17 binub18)
* for X in num 2/18 \ Y in num 1/17: replace binubX=binlbX+4*(binubY-binlbY) if binubX==upper

for num 1/18: rename probbinX pricebinX \ replace pricebinX=0 if pricebinX==. \ gen midbinX=(binubX+binlbX)/2
gen pricewin=.
for num 1/18: replace pricewin=pricebinX if releasedvalue>=binlbX & releasedvalue<binubX 
/*Note that this omits a few cases that were in the tails */
gen beta=.
replace sp500=sp500/100
for any nfpay rsxaut iclm napm: reg sp500 ameanerr if statistic=="X" \ replace beta=_b[ameanerr] if statistic=="X"
gen wealthwin=.
for num 1/18: replace wealthwin=1+beta*(midbinX-amean) if releasedvalue>=binlbX & releasedvalue<binubX
for num 1/18: gen wealthX= 1+beta*(midbinX-amean)
program drop _all

program define riskav
	version 6
	args lnf rho
	tempvar prob shadow
	quietly generate double `prob' = $ML_y1/(wealthwin^(-`rho'))
*	quietly generate double `prob' = (wealthwin^(-`rho'))/$ML_y1 
	quietly generate double `shadow'=0
	quietly for num 1/18: replace `shadow'=`shadow'+pricebinX/(wealthX^(-`rho')) if wealthX~=.
*	display(`rho')
	quietly replace `lnf'=ln(`prob'/`shadow')
end

ml model lf riskav (pricewin=)
ml max

*Thats all folks


